#----------------------------------------------------------------------
#  Script prova lettura file GCODE (Marlin) con Python
#  Autore: Andrea Pavan
#  Data: 27/09/2022
#----------------------------------------------------------------------


import numpy as np;
import re;
import time;
startTime = time.time();


#variabili
nozzleDiameter = 0.4;       #diametro nozzle
path = np.zeros([1,3],float);       #matrice Nx3 dei punti di arrivo
feedrate = np.zeros([1,1],float);       #vettore Nx1 dei feedrate di ciascun tratto lineare


#lettura file gcode
newPosition = np.zeros(3,float);        #vettore 1x3 punto corrente
newFeedrate = 0.0;      #feedrate corrente
with open('esempio_gcode.gcode') as gcode:
    for line in gcode:
        #si considerano solo i comandi G0 e G1
        if line[0:2] == 'G0' or line[0:2] == 'G1':
            line_params = re.split(r"\s+", line.split(';',1)[0]);
            for line_param in line_params:
                if line_param[0:1] == 'X':
                    newPosition[0] = float(line_param[1:]);
                elif line_param[0:1] == 'Y':
                    newPosition[1] = float(line_param[1:]);
                elif line_param[0:1] == 'Z':
                    newPosition[2] = float(line_param[1:]);
                elif line_param[0:1] == 'F':
                    newFeedrate = float(line_param[1:]);
            path = np.vstack([path, newPosition]);
            feedrate = np.vstack([feedrate, newFeedrate]);
        #else:
            #print(line);

endTime = time.time();
print('Tempo esecuzione: ', endTime-startTime, ' s\n');

